/**  @file bta_orientation.c
*  
*    @brief This file implements the pixel interpolation filter
*  
*    BLT_DISCLAIMER
*  
*    @author Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>

#ifndef BTA_EXCLUDE_FILTERS


#ifndef BTA_ORIENTATION_H_INCLUDED
#define BTA_ORIENTATION_H_INCLUDED


typedef struct BTA_FltOrientationInst {
    BTA_FltOrientationType orientationType;
    uint16_t degrees;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltOrientationInst;


BTA_Status BFLTorientationInit(BTA_FltOrientationConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTorientationClose(BTA_FltHandle *handle);
BTA_Status BFLTorientationApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
